/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.config;

import dev.terminalmc.clientsort.client.config.Config;
import dev.terminalmc.clientsort.client.config.Policy;
import dev.terminalmc.clientsort.client.config.Vec2i;
import dev.terminalmc.clientsort.util.Localization;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import joptsimple.internal.Strings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ClassPolicy(@NotNull String className, @Nullable Vec2i buttonOffset, @NotNull Policy sortPolicy, @NotNull Policy stackFillPolicy, @NotNull Policy transferPolicy, @NotNull TreeSet<Integer> ignoredSlots) {
    public static final String DATA_FORMAT = "%s,(%s),%s,%s,%s,(%s)";
    public static final String DATA_PATTERN_STRING = "^(.+),\\((?:(-?\\d+),(-?\\d+))?\\),([012]),([012]),([012]),\\(((?:\\d+(?:,\\d+)*)?)\\)$";
    public static final Pattern DATA_PATTERN = Pattern.compile("^(.+),\\((?:(-?\\d+),(-?\\d+))?\\),([012]),([012]),([012]),\\(((?:\\d+(?:,\\d+)*)?)\\)$");

    @NotNull
    public Vec2i getButtonOffset() {
        return this.buttonOffset == null ? Config.options().layoutOffset : this.buttonOffset;
    }

    public boolean canSort() {
        return !this.sortPolicy.equals((Object)Policy.NONE);
    }

    public boolean canStackFill() {
        return !this.stackFillPolicy.equals((Object)Policy.NONE);
    }

    public boolean canTransfer() {
        return !this.transferPolicy.equals((Object)Policy.NONE);
    }

    public boolean useSortKeybind() {
        return this.sortPolicy.keybind;
    }

    public boolean useStackFillKeybind() {
        return this.stackFillPolicy.keybind;
    }

    public boolean useTransferKeybind() {
        return this.transferPolicy.keybind;
    }

    public boolean showSortButton() {
        return this.sortPolicy.button;
    }

    public boolean showStackFillButton() {
        return this.stackFillPolicy.button;
    }

    public boolean showTransferButton() {
        return this.transferPolicy.button;
    }

    public String toDataString() {
        return String.format(DATA_FORMAT, this.className, this.buttonOffset == null ? "" : this.buttonOffset.x() + "," + this.buttonOffset.y(), this.sortPolicy.toSimpleString(), this.stackFillPolicy.toSimpleString(), this.transferPolicy.toSimpleString(), Strings.join(this.ignoredSlots.stream().map(String::valueOf).toList(), (String)","));
    }

    public static ClassPolicy fromDataString(String dataString, Set<String> oldClassNames) throws ParseException {
        Matcher matcher = DATA_PATTERN.matcher(dataString = dataString.strip());
        if (!matcher.matches()) {
            throw new ParseException(Localization.localized("error", "classPolicy.pattern", DATA_PATTERN_STRING).getString(), 0);
        }
        String className = matcher.group(1);
        if (!oldClassNames.contains(className)) {
            try {
                Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new ParseException(Localization.localized("error", "classPolicy.classNotFound", className).getString(), 0);
            }
        }
        return new ClassPolicy(className, matcher.group(2) == null ? null : new Vec2i(Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3))), Policy.fromSimpleString(matcher.group(4)), Policy.fromSimpleString(matcher.group(5)), Policy.fromSimpleString(matcher.group(6)), new TreeSet<Integer>(Arrays.stream(matcher.group(7).split(",")).filter(s -> !s.isBlank()).map(Integer::parseInt).sorted().toList()));
    }
}

